package w83a.w83aUtilidadesComunes;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;


import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

// TODO: Auto-generated Javadoc
/**
 * The Class U66aDateUtil.
 *
 * @author Deusto Sistemas
 */
public class W83aDateUtil {
	
	/**
	 * Instantiates a new u66a date util.
	 */
	public W83aDateUtil() {
    }
	
	/**
	 * Gets the single instance of U66aDateUtil.
	 *
	 * @return single instance of U66aDateUtil
	 */
	public static W83aDateUtil getInstance() {//NOPMD
        //If there isn't instance of this class, we have to create one
        if (instance == null) {
            //We need synchronization here to serialize (no multithread)
            //the invocations to this method.
            synchronized(W83aDateUtil.class) {
                if (instance == null) {
                    instance = new W83aDateUtil();
                }
            }
        }
        return instance;
    }

    /** The instance. */
    private static W83aDateUtil instance = null; //my own instance. Used in getInstance method
    
	/** The Constant EU_PATTERN. */
	public static final String EU_PATTERN="yyyy/MM/dd";
	
	/** The Constant ES_PATTERN. */
	public static final String ES_PATTERN="dd/MM/yyyy";
	
	public static final String EU_PATTERN_HORA="yyyy/MM/dd HH:mm:ss";
	public static final String ES_PATTERN_HORA="dd/MM/yyyy HH:mm:ss";
	public static final String EU_PATTERN_HORA_24="yyyy/MM/dd HH24:mm:ss";
	public static final String ES_PATTERN_HORA_24="dd/MM/yyyy HH24:mm:ss";
	public static final String EU_PATTERN_HORA_INSERT="yyyy/MM/dd HH24:mi:ss";
	public static final String ES_PATTERN_HORA_INSERT="dd/MM/yyyy HH24:mi:ss";

   /**
    * Gets the date.
    *
    * @param dateText the date text
    * @param pattern the pattern
    * @return the date
    * @throws Exception the exception
    */
   public Date getDate(String dateText, String pattern)
            throws Exception {

      Date date;

      try {
         SimpleDateFormat format = new SimpleDateFormat(pattern);
         date =  format.parse(dateText);

         return date;
      }
      catch (Exception e) {
         throw new Exception("Formato de Fecha incorrecto");
      }
   }

   
   
   /**
    * Gets the locale string from date.
    *
    * @param date the date
    * @param locale the locale
    * @return the locale string from date
    * @throws Exception the exception
    */
   public String getLocaleStringFromDate(Date date, Locale locale) throws Exception {

	    String strDate;
		String pattern;
		
		try {
			if ("eu".equals(locale.getLanguage())){
				pattern = this.EU_PATTERN;
			}
			else if ("es".equals(locale.getLanguage())){
				pattern = this.ES_PATTERN;
			}
			else{
				pattern = this.ES_PATTERN;
			}
		} catch (Exception e) {
			throw new Exception("getLocaleStringFromDate Locale incorrecto");
		}
		
		try {
			SimpleDateFormat format = new SimpleDateFormat(pattern);
			strDate = format.format(date);
		    return strDate;
		} catch (Exception e) {
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			throw new Exception("getLocaleStringFromDate Formato de Fecha incorrecto");
		}
	}
   
   /**
    * Gets the locale string from date.
    *
    * @param date the date
    * @param idioma the idioma
    * @return the locale string from date
    * @throws Exception the exception
    */
   public String getLocaleStringFromDate(Date date, String idioma) throws Exception {

	    String strDate;
		String pattern;
		
		try {
			if ("eu".equals(idioma)){
				pattern = this.EU_PATTERN;
			}
			else if ("es".equals(idioma)){
				pattern = this.ES_PATTERN;
			}
			else {
				pattern = this.ES_PATTERN;
			}
		} catch (Exception e) {
			throw new Exception("getLocaleStringFromDate Locale incorrecto idioma="+idioma);
		}
		
		try {
			SimpleDateFormat format = new SimpleDateFormat(pattern);
			strDate = format.format(date);
		    return strDate;
		} catch (Exception e) {
			throw new Exception("getLocaleStringFromDate Formato de Fecha incorrecto");
		}
	}
   /**
    * Gets the locale string from date.
    *
    * @param date the date
    * @param idioma the idioma
    * @return the locale string from date
    * @throws Exception the exception
    */
   public String getLocaleStringFromDateHora(Date date, String idioma) throws Exception {

	    String strDate;
		String pattern;
		
		try {
			if ("eu".equals(idioma)){
				pattern = this.EU_PATTERN_HORA;
			}
			else if ("es".equals(idioma)){
				pattern = this.ES_PATTERN_HORA;
			}
			else {
				pattern = this.ES_PATTERN_HORA;
			}
		} catch (Exception e) {
			throw new Exception("getLocaleStringFromDate Locale incorrecto idioma="+idioma);
		}
		
		try {
			SimpleDateFormat format = new SimpleDateFormat(pattern);
			strDate = format.format(date);
		    return strDate;
		} catch (Exception e) {
			throw new Exception("getLocaleStringFromDate Formato de Fecha incorrecto");
		}
	}
   /**
    * Gets the locale string from date.
    *
    * @param date the date
    * @param idioma the idioma
    * @return the locale string from date
    * @throws Exception the exception
    */
   public String getPatronStringFromDate(Date date, String patron) throws Exception {

	    String strDate;
		
		
		try {
			SimpleDateFormat format = new SimpleDateFormat(patron);
			strDate = format.format(date);
		    return strDate;
		} catch (Exception e) {
			throw new Exception("getLocaleStringFromDate Formato de Fecha incorrecto");
		}
	}
   
   
   
   
   /**
    * Gets the timestamp.
    *
    * @param dateText the date text
    * @param pattern the pattern
    * @return the timestamp
    * @throws Exception the exception
    */
   public Timestamp getTimestamp(String dateText, String pattern)
   throws Exception {
	
		Timestamp date;
		
		try {
		SimpleDateFormat format = new SimpleDateFormat(pattern);
		Date d = format.parse(dateText);
		date = new Timestamp(d.getTime());
		return date;
		}
		catch (Exception e) {
		throw new Exception("Formato de Fecha incorrecto");
		}
	}
   

   /**
    * Gets the current date time.
    *
    * @return the current date time
    */
   public Date getCurrentDateTime() {

      return  new GregorianCalendar().getTime();
   }

   /**
    * Gets the current date time.
    *
    * @param pattern the pattern
    * @return the current date time
    * @throws Exception the exception
    */
   public  String getCurrentDateTime(String pattern) throws Exception {

      String dateTime;
      Date date = this.getCurrentDateTime();
      
      dateTime = this.getDateTime(date, pattern);
      
      return dateTime;
   }

   /**
    * Gets the date time.
    *
    * @param date the date
    * @param pattern the pattern
    * @return the date time
    * @throws Exception the exception
    */
   public String getDateTime(Object date, String pattern) throws Exception {

      String dateTime = null;
      SimpleDateFormat format = new SimpleDateFormat(pattern);
      Date fecha = null;
      if (date instanceof java.sql.Date){
    	  fecha = new Date(((java.sql.Date)date).getTime());
      }
      else if (date instanceof java.sql.Timestamp){
    	  fecha = new Date(((java.sql.Timestamp)date).getTime());
      }
      else if (date instanceof java.util.Date){
    	  fecha = (Date)date;
      }
      else if (date instanceof java.lang.String){
    	  fecha = this.getDate((String)date, pattern);
      }
      else{
    	  throw new Exception ("No es un parametro de fecha");
      }
      dateTime = format.format(fecha);
      
      return dateTime;
   }

   // Das transcurridos desde 01-01-1970

   /**
    * Gets the current time days.
    *
    * @return the current time days
    */
   public double getCurrentTimeDays() {

      long ctm;
      double scale = 1000 * 60 * 60 * 24;

      ctm = System.currentTimeMillis();

      return ctm / scale;

   }

   /**
    * Gets the current time hours.
    *
    * @return the current time hours
    */
   public double getCurrentTimeHours() {

      long ctm;
      double scale = 1000 * 60 * 60;

      ctm = System.currentTimeMillis();

      return ctm / scale;

   }

   /**
    * Adds the minutes.
    *
    * @param srcDate the src date
    * @param mins the mins
    * @return the date
    */
   public Date addMinutes(Date srcDate, int mins) {

      Calendar c;

      c = Calendar.getInstance();
      c.setTime(srcDate);

      c.add(Calendar.MINUTE, mins);

      return (Date) c.getTime();

   }
   
   /**
    * Adds the minutes.
    *
    * @param srcDate the src date
    * @param mins the mins
    * @return the date
    */
   public Date addYears(Date srcDate, int years) {
	   
	   Calendar c;
	   
	   c = Calendar.getInstance();
	   c.setTime(srcDate);
	   
	   c.add(Calendar.YEAR, years);
	   
	   return (Date) c.getTime();
	   
   }
   
   /**
    * Adds the minutes.
    *
    * @param srcDate the src date
    * @param mins the mins
    * @return the date
    */
   public Date addMonths(Date srcDate, int months) {
	   
	   Calendar c;
	   Calendar c1;
	   
	   c = Calendar.getInstance();
	   c1 = Calendar.getInstance();
	   c.setTime(srcDate);
	   c.add(Calendar.MONTH, months);
	   int dias=c.getActualMaximum(Calendar.DAY_OF_MONTH);
	   c1.set(c.get(Calendar.YEAR), c.get(Calendar.MONTH) , dias);
	   return (Date) c1.getTime();
	   
   }
   
   /*
    * Calcula el n de das de un mes en concreto
    * */
   /**
    * Calcula dias.
    *
    * @param anyo the anyo
    * @param mes the mes
    * @return the int
    */
   public int calculaDias(int anyo, int mes){

	   if ( (mes == 1) || (mes == 3) || (mes == 5) || (mes == 7) || (mes == 8 ) || (mes == 10) || (mes == 12) ){
		   return 31;
	   }else if ( (mes == 4) || (mes == 6) || (mes == 9) || (mes == 11) ) {
		   return 30;
	   }else if (mes == 2){	
		   if ( ( ( ( anyo % 4 ) == 0 ) && ( ( anyo % 100 ) ) != 100 ) || ( ( anyo % 400 ) == 0 ) ) {	
			   return 29;	
		   }	
		   return 28;
	   }else{
		   return -1;
	   }
	}
   /**
	 * Formatear fecha1.
	 *
	 * @param f the f
	 * @param locale the locale
	 * @return the string
	 */
   public  String formatearFecha1(Date f, Locale locale){
		Calendar c  = Calendar.getInstance();
		c.setTime(f);
		String dia = new Integer(c.get(Calendar.DAY_OF_MONTH)).toString(); // NOPMD by Asier Valle on 18/05/10 9:47
		String mes = new Integer(c.get(Calendar.MONTH)+1).toString(); // NOPMD by Asier Valle on 18/05/10 9:47
		String anyo = new Integer(c.get(Calendar.YEAR)).toString(); // NOPMD by Asier Valle on 18/05/10 9:48
		if("es".equals(locale.getLanguage())){
			return dia+"/"+mes+"/"+anyo;
		}else{
			return anyo+"/"+mes+"/"+dia;
		}
	}
	
	/**
	 * Formatear fecha.
	 *
	 * @return the date
	 * @throws Exception the exception
	 */
   public  Date formatearFecha() throws Exception{		
		Date date = new Date();
		return date; // NOPMD
	}
   
	
	/**
	 * String to date idioma.
	 *
	 * @param fecha the fecha
	 * @param idioma the idioma
	 * @return the java.util. date
	 * @throws ParseException the parse exception
	 */
	public  java.util.Date stringToDateIdioma(String fecha,String idioma)throws ParseException {
		java.util.Date fechaF;
		
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){	
			fechaF = (new SimpleDateFormat("dd/MM/yyyy")).parse(fecha);
		}else{
			fechaF = (new SimpleDateFormat("yyyy/MM/dd")).parse(fecha);
		}
		
		return fechaF;
	}
	
	public String rellenarConCerosDate(String fecha,String idioma){
		StringTokenizer tokenizer = new StringTokenizer(fecha,"/");
		
		String dia;
		String mes;
		String anyo;
		
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			dia = tokenizer.nextToken();
			mes = tokenizer.nextToken();
			anyo = tokenizer.nextToken();
		}else{
			anyo = tokenizer.nextToken();			
			mes = tokenizer.nextToken();
			dia = tokenizer.nextToken();
		}
		for(int i = dia.length(),size=2;i<size;i++){
			dia = "0"+dia;//NOPMD
		}
		for(int i = mes.length(),size=2;i<size;i++){
			mes = "0"+mes;//NOPMD
		}
		for(int i = anyo.length(),size=2;i<size;i++){
			anyo = "0"+anyo;//NOPMD
		}
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			return dia+"/"+mes+"/"+anyo;
		}else{
			return anyo+"/"+mes+"/"+dia;
		}
	}
	
	/**Separa la fecha dada en [dia,mes,anyo] segn el idioma y lo mete en una lista
	 * @param fecha
	 * @param idioma
	 * @return
	 */
	public List separarDiaMesAnyo(String fecha,String idioma){
		List listaDia = new ArrayList();
		String dia;
		String mes;
		String anyo;
		StringTokenizer tokenizer = new StringTokenizer(fecha,"/");
		
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			dia = tokenizer.nextToken();
			mes = tokenizer.nextToken();
			anyo = tokenizer.nextToken();
		}else{
			anyo = tokenizer.nextToken();			
			mes = tokenizer.nextToken();
			dia = tokenizer.nextToken();
		}
		
		listaDia.add(dia);
		listaDia.add(mes);
		listaDia.add(anyo);
		return listaDia;
	}
	
	/**
	 * Devuelve el formato dd/mm/aaaa si el idioma que se le introduce es castellano, sino aaaa/mm/dd
	 * 
	 * @param idioma
	 * @return
	 */
	public String devolverFormatoIdioma(String idioma){
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			return ES_PATTERN;
		}else{
			return EU_PATTERN;			
		}
	}
	/**
	 * Devuelve el formato dd/mm/aaaa hh:mm:ss si el idioma que se le introduce es castellano, sino aaaa/mm/dd
	 * 
	 * @param idioma
	 * @return
	 */
	public String devolverFormatoHoraIdioma(String idioma){
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			return ES_PATTERN_HORA;
		}else{
			return EU_PATTERN_HORA;			
		}
	}
	/**
	 * Devuelve el formato dd/mm/aaaa hh24:mm:ss si el idioma que se le introduce es castellano, sino aaaa/mm/dd
	 * 
	 * @param idioma
	 * @return
	 */
	public String devolverFormatoHoraVeinticuatroIdioma(String idioma){
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			return ES_PATTERN_HORA_24;
		}else{
			return EU_PATTERN_HORA_24;			
		}
	}
	/**
	 * Devuelve el formato dd/mm/aaaa hh24:mm:ss si el idioma que se le introduce es castellano, sino aaaa/mm/dd
	 * 
	 * @param idioma
	 * @return
	 */
	public String devolverFormatoHoraVeinticuatroAlternativaIdioma(String idioma){
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			return W83aClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO;
		}else{
			return W83aClsConstantes.FORMATO_FECHA_COMPLETA_EUSKARA;			
		}
	}
	/**
	 * Devuelve el formato dd/mm/aaaa hh:mi:ss si el idioma que se le introduce es castellano, sino aaaa/mm/dd
	 * Se diferencia de la funcin anterior, 
	 * que si se intenta hacer una insert con el formato dd/mm/yyyy hh:mm:ss da el sgte error
	 * ORA-01810: el cdigo de formato aparece dos veces
	 * por lo que se ha sustituido por dd/mm/yyyy hh:mi:ss
	 * @param idioma
	 * @return
	 */
	public String devolverFormatoHoraIdiomaInsert(String idioma){
		if(W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			return ES_PATTERN_HORA_INSERT;
		}else{
			return EU_PATTERN_HORA_INSERT;			
		}
	}
	
	
	public String sabernombremes(int mes, String idioma) throws Q70GestorMensajesException {

		String[] meses={Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.enero",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.febrero",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.marzo",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.abril",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.mayo",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.junio",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.julio",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.agosto",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.septiembre",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.octubre",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.noviembre",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.diciembre",idioma)};
		 
		return (String)meses[mes];
	}
	
	public String sabernombremesmin(int mes, String idioma) throws Q70GestorMensajesException {

		String[] meses={Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.eneromin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.febreromin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.marzomin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.abrilmin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.mayomin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.juniomin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.juliomin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.agostomin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.septiembremin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.octubremin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.noviembremin",idioma),Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.cierre.diciembremin",idioma)};
		 
		return (String)meses[mes];
	}
	
	public StringBuffer devolverLiteralfechaentera(int dia, int mes, int anno, String idioma) throws Q70GestorMensajesException {

		StringBuffer sb=new StringBuffer();
		if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			sb.append(dia).append(" de ").append(sabernombremesmin(mes-1,idioma)).append(" de ").append(anno);
		}
		else{
			sb.append(anno).append("eko ").append(sabernombremesmin(mes-1,idioma)).append("ren ").append(dia).append("(e)an");
		}
		 
		return sb;
	}
	
	public StringBuffer devolverLiteralfechamin(int dia, int mes, int anno, String idioma) throws Q70GestorMensajesException {

		StringBuffer sb=new StringBuffer();
		if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			sb.append(dia).append("-").append(sabernombremesmin(mes-1,idioma)).append("-").append(anno);
		}
		else{
			sb.append(dia).append("-").append(sabernombremesmin(mes-1,idioma)).append("-").append(anno);
		}
		
	
		return sb;
	}
	
	public boolean compararfechas(Date date1, Date date2){
		long dif = date1.getTime() - date2.getTime();
		boolean valido=false;
		if (dif>=0){
			valido=true;
		}
		return valido;
		
	}
	
	public String calcularfechamenor(String araba, String bizkaia, String gipuzkoa) throws ParseException{
		
		SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
		long dif = (formatter.parse(araba)).getTime() - (formatter.parse(bizkaia)).getTime();
		if (dif<0){
			dif = (formatter.parse(araba)).getTime() - (formatter.parse(gipuzkoa)).getTime();
			if (dif<0){
				return araba;
			}
			else{
				return gipuzkoa;
			}
		}
		else{
			dif = (formatter.parse(bizkaia)).getTime() - (formatter.parse(gipuzkoa)).getTime();
			if (dif<0){
				return bizkaia;
			}
			else{
				return gipuzkoa;
			}
		}
		
	}
	
	public int getUltimoDiaDelMes(int anno, int mes) {//NOPMD
		if (mes==0){
			mes=W83aClsConstantes.DOCE;
			anno=anno-1;
		}
		Calendar cal = Calendar.getInstance();
        cal.set(anno,
                mes-1,
                1);
        return cal.getActualMaximum(Calendar.DAY_OF_MONTH);
    }

}
